<?php

// Configuration
$servername = "localhost";
$username = "remote_user";
$password = "MyPassword";
$dbname = "meta";


try {
    $conn = new PDO("mysql:host=$servername", $username, $password);
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "Connected successfully to MySQL server.\n\n";

    $excluded_dbs = ['information_schema', 'mysql', 'performance_schema', 'sys'];

    $stmt_dbs = $conn->prepare("SELECT schema_name FROM information_schema.schemata WHERE schema_name NOT IN ('" . implode("','", $excluded_dbs) . "')");
    $stmt_dbs->execute();
    $databases = $stmt_dbs->fetchAll(PDO::FETCH_COLUMN);

    if (empty($databases)) {
        echo "No user databases found to convert.\n";
    } else {
        echo "Found " . count($databases) . " user databases. Starting conversion...\n\n";

        foreach ($databases as $db) {
            echo "--- Processing database '{$db}' ---\n";

            // Step 1: Alter the database itself
            $sql_db = "ALTER DATABASE `{$db}` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
            $conn->exec($sql_db);
            echo "  Database '{$db}' default collation set to utf8mb4_general_ci.\n";

            // Step 2: Alter all tables within the database
            $stmt_tables = $conn->prepare("SELECT table_name FROM information_schema.tables WHERE table_schema = :db_name");
            $stmt_tables->bindParam(':db_name', $db);
            $stmt_tables->execute();
            $tables = $stmt_tables->fetchAll(PDO::FETCH_COLUMN);

            if (empty($tables)) {
                echo "  No tables found in this database.\n";
            } else {
                foreach ($tables as $table) {
                    echo "  -- Converting table `{$db}`.`{$table}` --\n";

                    // Alter the table to set the default character set and collation
                    $sql_table = "ALTER TABLE `{$db}`.`{$table}` CONVERT TO CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci";
                    $conn->exec($sql_table);
                    echo "    Table `{$db}`.`{$table}` default collation set.\n";

                    // Alter each column to explicitly set its character set and collation
                    $stmt_cols = $conn->prepare("SHOW FULL COLUMNS FROM `{$db}`.`{$table}` WHERE Type LIKE '%char%' OR Type LIKE '%text%'");
                    $stmt_cols->execute();
                    $columns = $stmt_cols->fetchAll(PDO::FETCH_ASSOC);

                    foreach ($columns as $column) {
                        $col_name = $column['Field'];
                        $col_type = $column['Type'];
                        $is_nullable = ($column['Null'] == 'YES') ? 'NULL' : 'NOT NULL';
                        $col_default = ($column['Default'] !== null) ? "DEFAULT '" . $column['Default'] . "'" : '';

                        $sql_col = "ALTER TABLE `{$db}`.`{$table}` MODIFY `{$col_name}` {$col_type} CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci {$is_nullable} {$col_default}";
                        $conn->exec($sql_col);
                        echo "    Column `{$col_name}` converted.\n";
                    }
                    echo "  -- Finished with table `{$db}`.`{$table}` --\n\n";
                }
            }
            echo "--- Finished with database '{$db}' ---\n\n";
        }
        echo "All databases, tables, and columns have been fully converted successfully! 🎉\n";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}

$conn = null;

?>